<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" Theme="Voxco" Inherits="Voxco.Reporting.Report_ReportLayout" 
    Title="<%$ Resources:Resource, VoxcoReporting%>" Codebehind="ReportLayout.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
<div id="reportLayout">   
	<telerik:RadScriptBlock ID="test" runat="server">
		<script type="text/javascript" >       
			function UpdateReportRequest()
			{			
				//$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("UpdateReportRequest");
			}
		</script>
    </telerik:RadScriptBlock>
    
    <asp:ObjectDataSource ID="ObjectTypeDataSource" runat="server" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.ObjectType">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="StatisticDataSource" runat="server" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.Statistic">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="SelectedColumnsDataSource" runat="server" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.SelectedReportLayoutColumns">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="SelectedRowsDataSource" runat="server" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.SelectedReportLayoutRows">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="SelectedStatisticDataSource" runat="server" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.SelectedReportLayoutStatistics">
    </asp:ObjectDataSource>
 
    <telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" CssClass="mainContent" Height="500px" OnAjaxRequest="MainAjaxManager_OnAjaxRequest">
    <br />
           
			<div class="frame"> 
				<div>
					<asp:Label ID="lbReportTitle" runat="server" Text="<%$ Resources:Resource, ReportTitle%>" Width="100px" />:
					<telerik:RadTextBox ID="TxtReportTitle" runat="server"  Width="650px">
					</telerik:RadTextBox>
				</div>				
				<div>
					<asp:Label ID="lbReportDescription" runat="server" Text="<%$ Resources:Resource, Description%>" Width="100px" />:
					<telerik:RadTextBox ID="TxtReportDescription" runat="server"  Width="650px">
					</telerik:RadTextBox>
				</div>				
			</div>
			<br />	
			
  
			<div style="float: left; width: 49%; height: 100%;">										
	
				<div style="float:left; width: 33%;">
					<asp:Label ID="GroupACol1" runat="server" Text="<%$ Resources:Resource, Type%>" CssClass="title" />
					<br />
					<telerik:RadGrid ID="grdObjectType" runat="server" AllowSorting="False" DataSourceID="ObjectTypeDataSource" 
					AllowMultiRowSelection="True" Height="276px" 
					EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
						<MasterTableView DataSourceID="ObjectTypeDataSource" DataKeyNames="ObjectTypeId" AutoGenerateColumns="False" NoMasterRecordsText="" Width="100%">
							<Columns>
								<telerik:GridClientSelectColumn UniqueName="Selected">
									<HeaderStyle HorizontalAlign="Left" Width="30px"/>
									<ItemStyle HorizontalAlign="Left" Width="30px" />
								</telerik:GridClientSelectColumn>
								<telerik:GridBoundColumn UniqueName="ObjectTypeId" DataField="ObjectTypeId" HeaderText="Id"  Display="false">
								</telerik:GridBoundColumn>
								<telerik:GridBoundColumn UniqueName="ObjectTypeName" DataField="ObjectTypeName" HeaderText="<%$ Resources:Resource, Type%>">
									<HeaderStyle Width="90%" HorizontalAlign="Left" />
									<ItemStyle Width="90%" HorizontalAlign="Left" />
								</telerik:GridBoundColumn>
							</Columns>
						</MasterTableView>
						<ClientSettings>
							<Selecting AllowRowSelect="True" />
							<Scrolling AllowScroll="True" UseStaticHeaders="true" />
						</ClientSettings>
					</telerik:RadGrid>								
				</div>
				
				<div style="float: right; width:65%;">
					<div>
						<div style="float: left; width: 25px; margin-top:50px;">
							<asp:ImageButton ID="btnAddObjectTypeToColumns" runat="server" ImageAlign="AbsMiddle" ToolTip="<%$ Resources:Resource, Insert %>" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddObjectTypeToColumns_Click"/>                                
							<asp:ImageButton ID="btnRemoveObjectTypeFromColumns" runat="server" ImageAlign="AbsMiddle" ToolTip="<%$ Resources:Resource, Delete %>" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveObjectTypeFromColumns_Click"/>
						</div> 
						<div style="float: left; width: 90%;">
							<asp:Label ID="Panel2" runat="server" Text="<%$ Resources:Resource, Columns %>" CssClass="title" />
							<br />
							<telerik:RadGrid ID="grdSelectedColumns" runat="server" AllowSorting="True" SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader%>"
							SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader%>" SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader%>" 
							DataSourceID="SelectedColumnsDataSource" AllowMultiRowSelection="True" Height="120px" AutoGenerateColumns="false" Width="100%"
							EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
								<MasterTableView DataSourceID="SelectedColumnsDataSource" DataKeyNames="ObjectTypeId" NoMasterRecordsText="">
									<Columns>
										<telerik:GridClientSelectColumn UniqueName="Selected">
											<HeaderStyle HorizontalAlign="Left" Width="30px" />
											<ItemStyle HorizontalAlign="Left" Width="30px" />
										</telerik:GridClientSelectColumn>
										<telerik:GridBoundColumn UniqueName="ObjectTypeId" DataField="ObjectTypeId" HeaderText="Id"  Display="false">
										</telerik:GridBoundColumn>
										<telerik:GridBoundColumn UniqueName="ObjectTypeName" DataField="ObjectTypeName" HeaderText="<%$ Resources:Resource, Columns %>"  SortExpression="ObjectTypeName">
											<HeaderStyle Width="90%" HorizontalAlign="Left" />
											<ItemStyle Width="90%" HorizontalAlign="Left" />
										</telerik:GridBoundColumn>
									</Columns>
								</MasterTableView>
								<ClientSettings>
									<Selecting AllowRowSelect="True" />
									<Scrolling AllowScroll="true" UseStaticHeaders="true"/>
								</ClientSettings>
							</telerik:RadGrid>	
						</div>									
					</div>
					
					<div style="text-align: center; clear: both; padding-top: 5px;">
						<asp:ImageButton ID="btnSwapColumnRows" Height="16px" runat="server" ImageUrl="~/icons/refresh.png" OnClick="btnSwapColumnRows_Click" />
					</div>
					
					<div>
						<div style="float: left; width: 25px; margin-top:50px;">
							<asp:ImageButton ID="btnAddObjectTypeToRows" runat="server" ImageAlign="AbsMiddle" ToolTip="<%$ Resources:Resource, Insert %>" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddObjectTypeToRows_Click"/>
							<asp:ImageButton ID="btnRemoveObjectTypeFromRows" runat="server" ImageAlign="AbsMiddle" ToolTip="<%$ Resources:Resource, Delete %>" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveObjectTypeFromRows_Click"/>
						</div>
						<div style="float: left; width: 90%;">
							<asp:Label ID="Panel3" runat="server" Text="<%$ Resources:Resource, Rows %>" CssClass="title" />
							<telerik:RadGrid ID="grdSelectedRows" runat="server" AllowSorting="True" SortingSettings-SortToolTip="<%$ Resources:Resource, SortingHeader%>" 
							SortingSettings-SortedAscToolTip="<%$ Resources:Resource, SortingHeader%>" SortingSettings-SortedDescToolTip="<%$ Resources:Resource, SortingHeader%>" 
							DataSourceID="SelectedRowsDataSource" AllowMultiRowSelection="True" Height="120px" AutoGenerateColumns="false" Width="100%"
							EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">
								<MasterTableView DataSourceID="SelectedRowsDataSource" DataKeyNames="ObjectTypeId" NoMasterRecordsText="">
									<Columns>
										<telerik:GridClientSelectColumn UniqueName="Selected">
											<HeaderStyle HorizontalAlign="Left" Width="30px" />
											<ItemStyle HorizontalAlign="Left" Width="30px" />
										</telerik:GridClientSelectColumn>
										<telerik:GridBoundColumn UniqueName="ObjectTypeId" DataField="ObjectTypeId" HeaderText="Id"  Display="false">
										</telerik:GridBoundColumn>
										<telerik:GridBoundColumn UniqueName="ObjectTypeName" DataField="ObjectTypeName" HeaderText="<%$ Resources:Resource, Rows %>"  SortExpression="ObjectTypeName">
											<HeaderStyle Width="90%" HorizontalAlign="left" />
											<ItemStyle HorizontalAlign="left" />
										</telerik:GridBoundColumn>
									</Columns>
								</MasterTableView>
								<ClientSettings>
									<Selecting AllowRowSelect="True" />
									<Scrolling AllowScroll="true" UseStaticHeaders="true"/>
								</ClientSettings>
							</telerik:RadGrid>									
						</div>						
					</div>
							
				</div>											
				<p style="height:1em;"></p>
				<div class="frame" style="clear: both;">
					<asp:Label ID="TitleGroupBy" runat="server" Text="<%$ Resources:Resource, GroupBy %>" CssClass="title" />
					<br />
					<asp:CheckBox ID="ChkInterviewers" runat="server" Text="<%$ Resources:Resource, Interviewers%>" ></asp:CheckBox><br />
					<asp:CheckBox ID="chkProject" runat="server" Text="<%$ Resources:Resource, ProjectGroupBy%>" ></asp:CheckBox><br />
				</div>				
			</div>
			
			<div style="float: right; width: 49%;">
				<div class="frame">	
					<asp:Label ID="panTotalOption" runat="server" Text="Options" CssClass="title" />
					<br />
					<asp:CheckBox ID="totalFilterH" runat="server" Checked="true" Text="<%$ Resources:Resource, DisplayHorizontalTotal %>" ></asp:CheckBox><br />
					<asp:CheckBox ID="totalFilterV" runat="server" Checked="true" Text="<%$ Resources:Resource, DisplayVerticalTotal%>" ></asp:CheckBox><br />
					<asp:CheckBox ID="chkGrandTotalFilter" runat="server" AutoPostBack="true" Checked="true" Text="<%$ Resources:Resource, DisplayGrandTotal%>" OnCheckedChanged="chkGrandTotalFilter_OnCheckedChanged" ></asp:CheckBox>
				</div>
				
				<div class="frame">
					<asp:Label ID="panDisplayOption" runat="server" Text="<%$ Resources:Resource, DisplayOptions %>" CssClass="title" />
					<br />
					
					<asp:Label id="lblLanguageChoice" runat="server" text="<%$ Resources:Resource, LabelLanguage %>" CssClass="paddingLabel" Width="150px" />
					<asp:DropDownList ID="cbLanuageChoice" Width="200px" runat="server" AutoPostBack="false" EnableTheming="true">						
						<asp:ListItem Value="EN" Text="EN" Selected="true" />
						<asp:ListItem Value="FR" Text="FR" />						
					</asp:DropDownList>
					<br />
				
					<asp:CheckBox ID="chkDisplayEmptyLines" runat="server" Text="<%$ Resources:Resource, DisplayEmptyLines %>" ></asp:CheckBox><br />
					<asp:CheckBox ID="chkVerticalStatistic" runat="server" Text="<%$ Resources:Resource, DisplayVerticalStatistics %>" ></asp:CheckBox><br />
					<br />
					
					<asp:Label id="lblRndOption" runat="server" text="<%$ Resources:Resource, RoundingOption %>" CssClass="paddingLabel" Width="150px" />
					<asp:DropDownList ID="cbRndOption" Width="200px" runat="server" AutoPostBack="false">						
						<asp:ListItem Value="Round" Text="<%$ Resources:Resource, Round %>" Selected="true" />
						<asp:ListItem Value="Truncate" Text="<%$ Resources:Resource, Truncate %>" />
						<asp:ListItem Value="RoundUp" Text="<%$ Resources:Resource, RoundUp %>" />						
					</asp:DropDownList>
					<br />
					
					<asp:Label ID="lblDecimal" runat="server" Text="<%$ Resources:Resource, Decimals %>" CssClass="paddingLabel" Width="150px" />
					<asp:Textbox ID="txtDecimal" runat="server" Text=""  MaxLength="1" Width="10px" ></asp:Textbox><br />
					<asp:RequiredFieldValidator ID="RequiredFieldValidatorDecimal" runat="server" ControlToValidate="txtDecimal"
					ErrorMessage="<%$ Resources:Resource, MustEnterNumber09 %>" Display="dynamic">
					</asp:RequiredFieldValidator>
					<asp:RangeValidator ID="RangeValidatorDecimal" runat="server" ControlToValidate="txtDecimal"
					ErrorMessage="<%$ Resources:Resource, MustEnterNumber09 %>" MaximumValue="9" MinimumValue="0"
					SetFocusOnError="True" Type="Integer" Display="dynamic">
					</asp:RangeValidator>
					<br />
					
					<asp:Label id="lblFormatTime" runat="server" text="<%$ Resources:Resource, FormatTimeTitle %>" CssClass="paddingLabel" Width="150px" />
					<asp:DropDownList ID="cbFormatTime" Width="200px" runat="server" AutoPostBack="false">
						<asp:ListItem Value="HHMMSS" Text="<%$ Resources:Resource, HHMMSS %>" Selected="true" />
						<asp:ListItem Value="Hours" Text="<%$ Resources:Resource, Hours %>" />
						<asp:ListItem Value="Minutes" Text="<%$ Resources:Resource, Minutes %>" />
						<asp:ListItem Value="Seconds" Text="<%$ Resources:Resource, Seconds %>" />						
					</asp:DropDownList>					
							
				</div>
							
				<div class="frame">
					<asp:Label ID="PanelPageLayout" runat="server" Text="<%$ Resources:Resource, PageLayout %>" CssClass="title" />
					<br />
					
					<asp:Label id="DisplayFilterDefinitionLabel" runat="server" text="<%$ Resources:Resource, DisplayFilterDefinition %>" CssClass="paddingLabel" Width="150px" />					
					<asp:DropDownList ID="cbDisplayFilterOptions" runat="server" AutoPostBack="true" OnSelectedIndexChanged="cbDisplayFilterOptions_OnSelectedIndexChanged" Width="200px">
						<asp:ListItem Value="None" Text="<%$ Resources:Resource, No %>"></asp:ListItem>
						<asp:ListItem Value="InHeader" Text="<%$ Resources:Resource, InReportHeader %>" Selected="true"></asp:ListItem>
						<asp:ListItem Value="InFooter" Text="<%$ Resources:Resource, InReportFooter %>"></asp:ListItem>
					</asp:DropDownList>
					<br />
						
					<asp:CheckBox ID="chkDisplayDateFilter" runat="server" Text="<%$ Resources:Resource, DisplayDateFilter %>" ></asp:CheckBox><br />
					<asp:CheckBox ID="chkDisplayTimeFilter" runat="server" Text="<%$ Resources:Resource, DisplayTimeFilter %>" ></asp:CheckBox><br />
					<asp:CheckBox ID="chkDisplayRespondentsFilter" runat="server" Text="<%$ Resources:Resource, DisplayRespondentsFilter %>" ></asp:CheckBox><br />							
				</div>	
			</div>	
			            
    </telerik:RadAjaxPanel>          
</div>
</asp:Content>

